Library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 
  

entity demux16_tb is
end entity demux16_tb;

architecture arch of demux16_tb is
	
        signal clk_tb:std_logic:='0';
        signal output_data0_tb:std_logic_vector(15 downto 0);
        signal output_data1_tb:std_logic_vector(15 downto 0);
        signal output_data2_tb:std_logic_vector(15 downto 0);
        signal output_data3_tb:std_logic_vector(15 downto 0);
        signal input_data_tb:std_logic_vector(15 downto 0);
       

        component demux16_sync is 
        generic(n:integer := 16);
	port( 
             clk: in std_logic;
	     output_data0: out std_logic_vector(n-1 downto 0);   
             output_data1: out std_logic_vector(n-1 downto 0);
             output_data2: out std_logic_vector(n-1 downto 0);
             output_data3: out std_logic_vector(n-1 downto 0);
             input_data: in std_logic_vector(n-1 downto 0));
                    
	end component demux16_sync;

begin 
        demuxl6_sync_component:
	component demux16_sync
	port map( 
	         
                  clk=>clk_tb,
                  output_data0=>output_data0_tb,
                  output_data1=>output_data1_tb,
                  output_data2=>output_data2_tb,
                  output_data3=>output_data3_tb,
                  input_data=>input_data_tb);
                       
		

  	clkproc:
		process
			begin
			Wait for 50 ns;
			clk_tb<=not(clk_tb);
                        
		end process; 


                        input_data_tb<="0000000000000000" ,
				       "0000001000000001" after 500 ns,
                                       "0000000010000000" after 550 ns,  --550ns 
                                       "0000000000110001" after 850 ns, --850
                                       "0000000001110001" after 950 ns, --950
				       "0000110000000001" after 1000 ns,  --1000
				       "0000001100000001" after 1050 ns,  --1050
                                       "0000000000000001" after 1350 ns, --1350
                                       "0000000000110001" after 1450 ns, --1450
                                       "0000000000000001" after 1750 ns; --1750
		        

    test_proc:
		process
			begin
			wait for 50 ns;
			assert( output_data0_tb= "0000000000000000")
			report "incorrect result"
			severity error;
			
		        wait for 450 ns; --500 ns
			assert( output_data1_tb= "0000000000000000")
			report "incorrect result"
			severity error;

			wait for 500 ns; -- 1000 ns
			assert( output_data2_tb= "0000000000000000")
			report "incorrect result"
			severity error;
                        
                        wait for 500 ns; -- 1000 ns
			assert( output_data3_tb= "0000000000000000")
			report "incorrect result"
			severity error;

 
		end process;
end architecture arch;
			
			
			
			


